#include <built_in.h>
#include <Si5351SDR.h>
#include <SSD1306OLED.c>
unsigned long Freq = 10000000;
unsigned long StepVal;
char LCDText[15];
char StepCnt = 0x03;
char ModeCnt = 0x01;

///////////////////////////////////////////////////////////////
 char Controls(){
   static signed short EncodeVals[] = {0,-1,1,0,};
   while(EncodIn){
    SelectMode();
    SelectStep();
   }
   while((EncodIn)== 0x00){
    SelectMode();
    SelectStep();
   }
   delay_ms(1);
   Freq+=(EncodeVals[EncodIn]*StepVal);
   if(freq > 16000000)freq = 16000000;
   if(freq < 201000) freq = 201000;
   return (EncodIn);
 }
///////////////////////////////////////////////
unsigned long SelectStep(){
 if(StepSW == 1){
  StepCnt++;
  while(StepSW == 1);
  delay_ms(20);
  if(StepCnt > 6)StepCnt = 1;
  switch(StepCnt){
   case 1: StepVal = 10; print_10Hz; break;
   case 2: StepVal = 100; print_100Hz; break;
   case 3: StepVal = 1000; print_1KHz;  break;
   case 4: StepVal = 5000; print_5KHz;  break;
   case 5: StepVal = 100000; print_100KHz;  break;
   case 6: StepVal = 1; print_1Hz; break;
  }
 }
  return StepVal;
}
///////////////////////////////////////////////////////
void DisplayFreq(){
 longtostr(Freq, LCDText);
 LCDText[0] =  LCDText[3];
 LCDText[1] =  LCDText[4];
 LCDText[2] = 0;
 SSD1306_GotoXY(1,17);
 SSD1306_TextSize(2);
 SSD1306_Print(LCDText);
 SSD1306_Print(".");
 LCDText[0] =  LCDText[5];
 LCDText[1] =  LCDText[6];
 LCDText[2] =  LCDText[7];
 LCDText[3] =  LCDText[8];
 LCDText[4] =  LCDText[9];
 LCDText[5] =  LCDText[10];
 LCDText[6] = 0;
 SSD1306_Print(LCDText);
 SSD1306_Display();
}
/////////////////////////////////////////////////////////
void SelectMode(){
 if(ModeSW == 1){
   ModeCnt++;
   while(ModeSW == 1);
   delay_ms(20);
   if(ModeCnt > 3)ModeCnt = 1;
   switch(ModeCnt){
    case 1: AMSel; print_AM; break;
    case 2: LSBSel; print_LSB; break;
    case 3: USBSel; print_USB; break;
   }
   sendRegister(SI_PLL_RESET, 0xA0);
 }
}
/////////////////////////////////////////////////////////
void Init_Main(){
 OSCCON = 0b01111010; //set up for 16 MHZ internal oscillator
 ANSELA = 0X00; //set up for use as A2D
 ANSELC = 0X00;
 PORTA = 0X00;
 TRISA = 0xFF;
 TRISC = 0x00;
 PORTC = 0X00;
 APFCON0 = 0x00;
 APFCON1 = 0x00;
 INLVLA = 0x00;
 I2C1_Init(400000);
 delay_ms(20);
 sendRegister(CLK_ENABLE_CONTROL, 0x04);
 sendRegister(SI_CLK0_CONTROL, 0x0F);
 sendRegister(SI_CLK1_CONTROL, 0x0F);
 si5351aSetFrequency(freq);
 sendRegister(SI_PLL_RESET, 0xA0);
 StepVal = 1000;
 ///////////////////////////////////////////////////////////
 SSD1306_Begin(SSD1306_SWITCHCAPVCC, SSD1306_I2C_ADDRESS);
 SSD1306_ClearDisplay();
 SSD1306_Color = true;
 SSD1306_TextSize(1);
 SSD1306_GotoXY(110,23);
 SSD1306_Print("MHz");
 DisplayFreq();
 SSD1306_TextSize(2);
 print_AM;
 print_1KHz;
}
////////////////////////////////////////////////////
void main() {
 Init_Main();
 while(1){
  if(Controls()){
   si5351aSetFrequency(freq);
   DisplayFreq();
  }
 }
}